<?php

declare(strict_types=1);

namespace Erlage\Photogram\Data\Models\Collection;

use Erlage\Photogram\Data\Dtos\Collection\CollectionDisplayImageDTO;

trait TraitCollectionSetters
{
    use TraitCollectionProperties;

    /**
     * @return static 
     */
    final public function setId(string $id)
    {
        $this -> id = $id;

        return $this;
    }

    /**
     * @return static 
     */
    public function setOwnerUserId(string $ownerUserId)
    {
        $this -> ownerUserId = $ownerUserId;

        return $this;
    }

    /**
     * @return static 
     */
    public function setDisplayTitle(string $displayTitle)
    {
        $this -> displayTitle = $displayTitle;

        return $this;
    }

    /**
     * @return static 
     */
    public function setDisplayImage(CollectionDisplayImageDTO $displayImage)
    {
        $this -> displayImage = $displayImage;

        return $this;
    }

    /**
     * @return static 
     */
    public function setStampRegistration(string $stampRegistration)
    {
        $this -> stampRegistration = $stampRegistration;

        return $this;
    }

    /**
     * @return static 
     */
    public function setStampLastUpdate(string $stampLastUpdate)
    {
        $this -> stampLastUpdate = $stampLastUpdate;

        return $this;
    }
}
